// ----------------------------------------------------------------------
// TransferItemTrigger
//
// Transfers a custom item to the player.  The Touch function is not 
// implemented, so this needs to be triggered by name - either from
// another trigger or from ConEdit
// ----------------------------------------------------------------------
// ======================================================================
// Upgraded by WCCC @ 6/10/11 5:00 PM
// Now has proper failsafes and sets
// Flags in all fail scenarios except those where the item is not valid.
// ======================================================================

class UberTransferItemTrigger extends Trigger;

var() Class<Inventory> transferItem;
var() int NumToGive;
var() name FailFlagName;
var() bool bWarnBadClass;

singular function Trigger(Actor Other, Pawn Instigator)
{
	local Inventory invItemTo;
	local DeusExPlayer player;

     local ConPlay con;
     local ConWindowActive cw;

	local bool bIsPickup;
	local bool bMaxedCopies;
	local DeusExPickup CurP;
	local inventory CurI;
	local Weapon CurW;

	if (TransferItem == None)
	{
	 if (bWarnBadClass) player.AddNote("ERROR, TransferItemTrigger failed to find proper class!");
	 return;
	}

	 player = DeusExPlayer(GetPlayerPawn());

	 CurI = Player.FindInventoryType(transferItem);

	if (DeusExPickup(CurI) != None)
	{
	 CurP = DeusExPickup(CurI);
	 
	 if (CurP.MaxCopies - CurP.NumCopies < NumToGive)
	 {
	  Player.FlagBase.SetBool(FailFlagName, True,, -1);
	  return;
	 }

	}

	if (Weapon(CurI) != None)
	{
	 CurW = Weapon(CurI);

	 if ( (CurW.ReloadCount == 0) && (CurW.PickupAmmoCount == 0) && (CurW.AmmoName != None) )
	 {
	  Player.FlagBase.SetBool(FailFlagName, True,, -1);
	  return;
	 }
	}

	if (transferItem != None)
	{
		//player = DeusExPlayer(GetPlayerPawn());

		if (player != None)
		{
			// Spawn the item
			invItemTo = Spawn(transferItem);

			if (CurI == None && Player.FindInventorySlot(invItemTo, True) == False)
			{
			  Player.FlagBase.SetBool(FailFlagName, True,, -1);
			  return;
			}

			// If this was a DataVaultImage, then the image needs to be 
			// properly added to the datavault
			if (invItemTo.IsA('DataVaultImage'))
			{
				invItemTo.GiveTo(player);
				player.AddImage(DataVaultImage(invItemTo));

                     //...THEN THIS (TO GET THE "RECEIVED" WINDOW AND THEN SHOW IT)
                     con = player.conPlay;
                     cw = con.conWinThird;
                     cw.ShowReceivedItem(invItemTo, 1);

			}
			else	
			{	
				// Give item to the player	
				invItemTo.GiveTo(player);
				player.UpdateBeltText(invItemTo);

                     //...THEN THIS (TO GET THE "RECEIVED" WINDOW AND THEN SHOW IT)
                     con = player.conPlay;
                     cw = con.conWinThird;
                     cw.ShowReceivedItem(invItemTo, 1);
			}

		}
	}



}

defaultproperties
{
     bTriggerOnceOnly=False
     bCollideActors=False
     NumToGive=1
}
